clear all
capture log close
log using "estimationlog.txt", replace text

**********************************************************************
**Estimation commands for Governance and Conflict Relapse Paper ******
**Figures in: GovernanceConflictRelapse\Figures					******
**Results in: GovernanceConflictRelapse\STATA\Results	 		******
**log: GovernanceConflictRelapse\STATA\estimationlog.txt    	******
**********************************************************************

set scheme s1mono

capture adopath + m:\ado

use "governancedata.dta", clear


/* This dofile runs the regressions currently presented in Table 1 plus associated figures; 
	as well as the formal/informal institutions analysis */
include "MainAnalysis"

/*This do file calculated the substantive effects */

include "SubstantiveEffects.do"

/* The FormalVsInformal_2012.do dofile runs the analyzes of formal vs informal institutions currently presented in Table 3 */
include "FormalvsInformalInstAnalysis.do"

